------------------------------------------------------------------------------
-- Introduction, select HQ
------------------------------------------------------------------------------
function start1stChapter()

	Logic.SetShareExplorationWithPlayerFlag(1,8,1)

	CreateChestOpener("Ari")
	CreateChestOpener("Headhunter")
	CreateChestOpener("Dario")
	CreateChestOpener("Pilgrim")
	CreateChestOpener("Helias")
	CreateChestOpener("Yuki")
	StartChestQuest()
	
	-- Setup AI
	CreatePlayer2()
	CreatePlayer8()

	-- Spawn troops
	CreateArmyP8Defense()
	CreateArmyTribalCamps()
	CreateArmyPlayer()
	CreateArmyBridges()

	-- briefing
	CreateBriefingPrelude()

	start1stSubChapter()
	start2ndSubChapter()

	CreateNPCHQ1()
	CreateNPCHQ2()
	CreateNPCHQ3()

	AddDefeatEntity("AllyHQ")
	CreateQuestDefeat()
	
end
function end1stChapter()
	
	ResolveBriefing(briefingPreludeShowHQ1)
	ResolveBriefing(briefingPreludeShowHQ2)
	ResolveBriefing(briefingPreludeShowHQ3)
	ResolveBriefing(briefingPreludeQuestSelectHQQuest)

	StopQuestDefeat()
	
	AddDefeatEntity("PlayerHQ")
	
	createPoisonTraps()
	
	-- Stop winter
	StartWinter(1)

	-- Let nephilims attack player 5 (other hqs)
	SetHostile(2,5)

	start2ndChapter()

end
------------------------------------------------------------------------------
-- build bridges
------------------------------------------------------------------------------
function start2ndChapter()
	
	CreateDelayedBriefingBridges()
	
	CreateQuestBridges()

end
function end2ndChapter()

	ResolveBriefing(briefingBridgesQuest)

	StartCutscene(Cutscenes[THRESHOLDONECUTSCENE], start3rdChapter)
				
end

------------------------------------------------------------------------------
-- clean up ruins
------------------------------------------------------------------------------
function start3rdChapter()

	CreateArmyNephilimsHQ()

	CreateBriefingCleanUpRuins()

	CreateQuestCleanUpRuins()
	
	CreateNPCGate1()
	CreateNPCGate2()

	-- open gate and move army to new position
	ReplaceEntity("NephilimMainGate", Entities.XD_WallStraightGate)

end
	
function end3rdChapter()

	StartSimpleJob("KillAllInEndBaseQuest")

	--ResolveBriefing(briefingCleanUpRuinsQuest)

	--StartCutscene(Cutscenes[MISSIONCOMPLETECUTSCENE], Victory)
	
end

function KillAllInEndBaseQuest()
	local _entitiesInEndBase = {Logic.GetPlayerEntitiesInArea(2, nil, 69884.02, 54655.40, 14500, 1, nil)}
	if _entitiesInEndBase[1] <= 0 then
		ResolveBriefing(briefingCleanUpRuinsQuest)

		StartCutscene(Cutscenes[MISSIONCOMPLETECUTSCENE], Victory)
		return true
	end
	return false
end

------------------------------------------------------------------------------
-- gate 1
------------------------------------------------------------------------------
function start1stSubChapter()

	CreateQuestGate1Key()

	--CreateNPCGate1()

end
function end1stSubChapter()

	ReplaceEntity("Gate1", Entities.XD_DarkWallStraightGate)

	MoveAndVanish("NPC_Gate1", GetPosition("P8_DefensePoint1"))

end
------------------------------------------------------------------------------
-- gate 2
------------------------------------------------------------------------------
function start2ndSubChapter()

	CreateQuestGate2Key()

	--CreateNPCGate2()

end
function end2ndSubChapter()

	ReplaceEntity("Gate2", Entities.XD_DarkWallStraightGate)

	MoveAndVanish("NPC_Gate2", GetPosition("P8_DefensePoint1"))

end